// After Effects ExtendScript: mono_CompRenamer (ウィンドウを閉じないバージョン / 終了ボタン)

(function () {
    // --- GUIの構築 ---
    var win = new Window("palette", "mono_CompRenamer", undefined);
    win.orientation = "column";
    win.alignChildren = ["fill", "top"];

    // 1. 操作選択パネル
    var operationPanel = win.add("panel", undefined, "操作の種類");
    operationPanel.orientation = "row";
    operationPanel.alignChildren = "left";
    var rbReplace = operationPanel.add("radiobutton", undefined, "置換");
    var rbPrefix = operationPanel.add("radiobutton", undefined, "プレフィックス追加");
    var rbSuffix = operationPanel.add("radiobutton", undefined, "サフィックス追加");
    rbReplace.value = true;

    // 2. 入力フィールドパネル
    var inputPanel = win.add("panel", undefined, "設定");
    inputPanel.alignChildren = ["right", "top"];

    var groupFind = inputPanel.add("group");
    groupFind.add("statictext", undefined, "検索する文字列:");
    var etFind = groupFind.add("edittext", [0, 0, 180, 20], "");

    var groupReplace = inputPanel.add("group");
    groupReplace.add("statictext", undefined, "置換後の文字列:");
    var etReplace = groupReplace.add("edittext", [0, 0, 180, 20], "");

    var groupAdd = inputPanel.add("group");
    groupAdd.add("statictext", undefined, "追加する文字列:");
    var etAdd = groupAdd.add("edittext", [0, 0, 180, 20], "");

    var groupFilter = inputPanel.add("group");
    groupFilter.add("statictext", undefined, "対象を絞り込む文字列 (任意):");
    var etFilter = groupFilter.add("edittext", [0, 0, 180, 20], "");

    // 3. 適用範囲パネル
    var scopePanel = win.add("panel", undefined, "適用範囲");
    scopePanel.orientation = "row";
    scopePanel.alignChildren = "left";
    var rbSelected = scopePanel.add("radiobutton", undefined, "選択したコンポジション");
    var rbAll = scopePanel.add("radiobutton", undefined, "プロジェクト全体");
    rbAll.value = true;

    // 4. 実行ボタン
    var buttonGroup = win.add("group");
    buttonGroup.orientation = "row";
    buttonGroup.alignment = "center";
    var btnExecute = buttonGroup.add("button", undefined, "実行", { name: "ok" });
    // ★「キャンセル」を「終了」に変更
    var btnCancel = buttonGroup.add("button", undefined, "終了", { name: "cancel" });

    // --- GUIの制御ロジック ---
    function updateUI() {
        var isReplace = rbReplace.value;
        etFind.enabled = isReplace;
        etReplace.enabled = isReplace;
        etAdd.enabled = !isReplace;
        etFilter.enabled = !isReplace;
    }
    rbReplace.onClick = rbPrefix.onClick = rbSuffix.onClick = updateUI;

    // --- 実行ロジック ---
    btnExecute.onClick = function () {
        var proj = app.project;
        if (!proj) {
            alert("プロジェクトが開かれていません。");
            return;
        }

        var targetComps = [];
        if (rbSelected.value) {
            var selection = proj.selection;
            if (selection.length === 0) {
                alert("コンポジションが選択されていません。プロジェクトパネルで対象のコンポジションを選択してください。");
                return;
            }
            for (var i = 0; i < selection.length; i++) {
                if (selection[i] instanceof CompItem) {
                    targetComps.push(selection[i]);
                }
            }
            if (targetComps.length === 0) {
                alert("選択されたアイテムの中にコンポジションがありませんでした。");
                return;
            }
        } else {
            for (var i = 1; i <= proj.numItems; i++) {
                if (proj.item(i) instanceof CompItem) {
                    targetComps.push(proj.item(i));
                }
            }
        }

        var changedCount = 0;
        app.beginUndoGroup("mono_CompRenamer: コンポジション名を一括編集");
        try {
            if (rbReplace.value) {
                var findText = etFind.text;
                if (findText === "") {
                    alert("検索する文字列を入力してください。");
                    return;
                }
                var replaceText = etReplace.text;
                var regex = new RegExp(findText, "g");

                for (var j = 0; j < targetComps.length; j++) {
                    var currentItem = targetComps[j];
                    if (currentItem.name.indexOf(findText) !== -1) {
                        currentItem.name = currentItem.name.replace(regex, replaceText);
                        changedCount++;
                    }
                }

            } else {
                var addText = etAdd.text;
                var filterText = etFilter.text;

                for (var j = 0; j < targetComps.length; j++) {
                     var currentItem = targetComps[j];
                    if (filterText === "" || currentItem.name.indexOf(filterText) !== -1) {
                        if (rbPrefix.value) {
                            currentItem.name = addText + currentItem.name;
                        } else {
                            currentItem.name = currentItem.name + addText;
                        }
                        changedCount++;
                    }
                }
            }
            
            alert(changedCount + "個のコンポジション名を編集しました。");

        } catch (e) {
            alert("エラーが発生しました: " + e.toString());
        } finally {
            app.endUndoGroup();
        }
    };

    btnCancel.onClick = function () {
        win.close();
    };

    win.onShow = function() {
        updateUI();
    };
    win.center();
    win.show();
})();